/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.updates;

import com.ibm.hsc.websm.updates.PIUpdateDefines;
import com.ibm.hsc.websm.updates.PIUpdateErrorIds;
import com.ibm.hsc.websm.updates.PIUpdateException;
import com.ibm.hwmca.base.updates.MCFFileParser;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CoverLetterInformation
implements PIUpdateErrorIds,
PIUpdateDefines {
    private static final String TRACE_MASKT = "XUPDCLIT";
    private static final String TRACE_MASKF = "XUPDCLIF";
    private static final String TRACE_MASKD = "XUPDCLID";
    private int level;
    private boolean disruptive;
    private LocalizableText fixInformation;

    public CoverLetterInformation(File file, int n, int n2) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> CoverLetterInformation()");
        this.level = n;
        String string = file.getName();
        Trace.trace((String)TRACE_MASKD, (Object)("name=[" + string + "]"));
        String string2 = file.getPath();
        Trace.trace((String)TRACE_MASKD, (Object)("path=[" + string2 + "]"));
        int n3 = Integer.parseInt(string.substring(12, 15));
        Trace.trace((String)TRACE_MASKD, (Object)("lastDisruptive= " + n3));
        this.disruptive = true;
        if (n3 <= n2 && n > n2) {
            this.disruptive = false;
        }
        try {
            this.fixInformation = new LocalizableText("");
            MCFFileParser mCFFileParser = new MCFFileParser(string2);
            Document document = mCFFileParser.getDocument();
            String string3 = "000" + n;
            String string4 = string3.substring(string3.length() - 3);
            String string5 = string.substring(0, 8);
            string5 = string5 + string4 + "_";
            this.traverse(document, string5);
        }
        catch (Exception exception) {
            PIUpdateException pIUpdateException = new PIUpdateException(-1992, exception);
            this.fixInformation = new LocalizableText("com.ibm.hsc.common.bundles.UpdatesBundle", "COVER_LETTER_READ_FAILURE");
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- CoverLetterInformation()");
    }

    public int getLevel() {
        Trace.trace((String)TRACE_MASKT, (Object)"<> getLevel()");
        return this.level;
    }

    public boolean getDisruptive() {
        Trace.trace((String)TRACE_MASKT, (Object)"<> getDisruptive()");
        return this.disruptive;
    }

    public LocalizableText getFixInformation() {
        Trace.trace((String)TRACE_MASKT, (Object)"<> getFixInformation()");
        return this.fixInformation;
    }

    private void traverse(Node node, String string) throws HException {
        Trace.trace((String)TRACE_MASKT, (Object)"-> traverse()");
        short s = node.getNodeType();
        String string2 = "";
        if (s == 9) {
            Trace.trace((String)TRACE_MASKD, (Object)"traversing Document node");
            Document document = (Document)node;
            this.traverse(document.getDocumentElement(), string);
        } else if (s == 1) {
            String string3 = node.getNodeName();
            Trace.trace((String)TRACE_MASKD, (Object)("name of node=[" + string3 + "]."));
            if (string3.equals("fixpacks")) {
                NodeList nodeList = node.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Trace.trace((String)TRACE_MASKD, (Object)("Calling traverse for [" + nodeList.item(i).getNodeName() + "]."));
                    this.traverse(nodeList.item(i), string);
                }
            } else if (string3.equals("fixpack")) {
                String string4 = "";
                String string5 = "";
                String string6 = "";
                String string7 = "";
                NamedNodeMap namedNodeMap = node.getAttributes();
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    Node node2 = namedNodeMap.item(i);
                    string4 = node2.getNodeName();
                    if (!string4.equals("name")) continue;
                    String string8 = node2.getNodeValue();
                    Trace.trace((String)TRACE_MASKD, (Object)("fixpackName=[" + string8 + "] checkString=[" + string + "]"));
                    if (!string8.startsWith(string)) continue;
                    NodeList nodeList = node.getChildNodes();
                    for (int j = 0; j < nodeList.getLength(); ++j) {
                        Node node3 = nodeList.item(j);
                        String string9 = node3.getNodeName();
                        Trace.trace((String)TRACE_MASKD, (Object)("name of child node=[" + string9 + "]."));
                        if (!string9.equals("update")) continue;
                        NodeList nodeList2 = node3.getChildNodes();
                        for (int k = 0; k < nodeList2.getLength(); ++k) {
                            Node node4 = nodeList2.item(k);
                            String string10 = node4.getNodeName();
                            Trace.trace((String)TRACE_MASKD, (Object)("name of grandchild node=[" + string10 + "]."));
                            if (!string10.equals("description_text")) continue;
                            String string11 = node4.getNodeValue();
                            Trace.trace((String)TRACE_MASKD, (Object)("Value of grandchild node=[" + string11 + "]."));
                            NamedNodeMap namedNodeMap2 = node4.getAttributes();
                            Trace.trace((String)TRACE_MASKD, (Object)("Attributes of grandchild node=[" + namedNodeMap2 + "]."));
                            NodeList nodeList3 = node4.getChildNodes();
                            Trace.trace((String)TRACE_MASKD, (Object)("Child of grandchild node=[" + nodeList3 + "]."));
                            for (int i2 = 0; i2 < nodeList3.getLength(); ++i2) {
                                Node node5 = nodeList3.item(i);
                                String string12 = node5.getNodeName();
                                Trace.trace((String)TRACE_MASKD, (Object)("Name of attribute=[" + string12 + "]."));
                                String string13 = node5.getNodeValue();
                                Trace.trace((String)TRACE_MASKD, (Object)("Value of attribute=[" + string13 + "]."));
                                String string14 = this.fixInformation.toString() + string13 + System.getProperty("line.separator");
                                this.fixInformation = new LocalizableText(string14);
                            }
                        }
                    }
                }
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- traverse()");
    }
}

